<?php
/*
 * Plugin Name: Wordpress Custom Post Type
 * Description: 포스트 유형 추가 예제 플러그인
 * Version:   1.0.0
 * Author:    HiSEON
 * Author URI:  https://hiseon.me/
 */

function create_my_story() {
  register_post_type('my_stories',
    array(
      'labels' => array(
        'name' => 'My Stories',
        'singular_name' => 'My Story',
        'add_new' => 'Add New',
        'add_new_item' => 'Add New My Story',
        'edit' => 'Edit',
        'edit_item' => 'Edit My Story',
        'new_item' => 'New My Story',
        'view' => 'View',
        'view_item' => 'View My Story',
        'search_items' => 'Search My Stories',
        'not_found' => 'No My Stories found',
        'not_found_in_trash' => 'No My Stories found in Trash',
        'parent' => 'Parent My Story'
      ),

      'public' => true,

      'menu_position' => 15,
      'supports' => array('title', 'editor'),
      /* 'supports' => array('title', 'editor', 'comments', 'thumbnail', 'custom-fields'), */
      'taxonomies' => array(''),
      'menu_icon' => 'dashicons-smiley',
      'has_archive' => true
    )
  );
}

add_action('init', 'create_my_story');

function my_admin() {
  add_meta_box('my_story_meta_box',
    'My Story Details',
    'display_my_story_meta_box',
    'my_stories', 'normal', 'high'
  );
}

add_action('admin_init', 'my_admin');

function display_my_story_meta_box($my_story) {
  $story_memo = esc_html(get_post_meta($my_story->ID, 'story_memo', true));
  $story_rating = intval(get_post_meta($my_story->ID, 'story_rating', true));
?>
  <table>
    <tr>
      <td style="width: 100%">Story Memo</td>
      <td><input type="text" size="80" name="my_story_memo" value="<?php echo $story_memo; ?>" /></td>
    </tr>
    <tr>
      <td style="width: 150px">Story Rating</td>
      <td>
        <select style="width: 100px" name="my_story_rating">
          <?php for ($rating = 5; $rating >= 1; $rating --) { ?>
            <option value="<?php echo $rating; ?>" <?php echo selected($rating, $story_rating); ?>>
              <?php echo $rating; ?> stars
            </option>
          <?php } ?>
        </select>
      </td>
    </tr>
  </table>
<?php
}

add_action('save_post', 'add_my_story_fields', 10, 2);

function add_my_story_fields($my_story_id, $my_story) {
  if ($my_story->post_type == 'my_stories') {
    if (isset($_POST['my_story_memo']) && $_POST['my_story_memo'] != '') {
      update_post_meta($my_story_id, 'story_memo', $_POST['my_story_memo']);
    }
    if (isset($_POST['my_story_rating']) && $_POST['my_story_rating'] != '') {
      update_post_meta($my_story_id, 'story_rating', $_POST['my_story_rating']);
    }
  }
}

function include_template_function($template_path) {
  if (get_post_type() == 'my_stories') {
    if (is_single()) {
      if ($theme_file = locate_template(array ('single-my_stories.php'))) {
        $template_path = $theme_file;
      } else {
        $template_path = plugin_dir_path(__FILE__) . '/single-my_stories.php';
      }
    }
  }
  return $template_path;
}

add_filter('template_include', 'include_template_function', 1);

?>
