<?php
/*
 * Plugin Name: Wordpress Ajax
 * Description: 워드프레스 Ajax 예제 플러그인
 * Version:   1.0.0
 * Author:    HiSEON
 * Author URI:  https://hiseon.me/
 */

add_action('wp_ajax_callme', 'callme_func');
add_action('wp_ajax_nopriv_callme', 'callme_func');

function callme_func() {
	echo "hello, world :-)";
	wp_die();
}

add_action ('wp_enqueue_scripts', 'enqueue_ajax_script');

function enqueue_ajax_script() {
  $path = plugins_url() . "/". basename(dirname(__FILE__)) . "/";

  wp_enqueue_script('jquery');
  wp_enqueue_script('ajax', $path . 'ajax.js' );

  wp_localize_script( 'ajax', 'ajax_object',
    array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'we_value' => 1234 ) );
}

?>
