<?php

if(!class_exists('WP_List_Table')) {
  require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class admin_list_table extends WP_List_Table {
  public function __construct() {
    parent::__construct(array(
      'singular' => 'Customer',  //singular name of the listed records
      'plural'   => 'Customers', //plural name of the listed records
      'ajax'     => false,       //should this table support ajax?
      'screen'   => null
    ));
  }

  protected function get_table_name() {
    global $wpdb;
    return $wpdb->prefix . "customers";
  }

  public function get_item_data($per_page = 5, $page_number = 1) {
    global $wpdb;

    $sql = "SELECT * FROM ". $this->get_table_name();

    if (!empty($_REQUEST['orderby'])) {
      $sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
      $sql .= ! empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' ASC';
    }

    $sql .= " LIMIT $per_page";
    $sql .= ' OFFSET ' . ($page_number - 1) * $per_page;

    return $wpdb->get_results($sql, 'ARRAY_A');
  }

  public function delete_item($id) {
    global $wpdb;

    $wpdb->delete(
      $this->get_table_name(),
      array('ID' => $id),
      array('%d')
    );
  }

  public function record_count() {
    global $wpdb;

    $sql = "SELECT COUNT(*) FROM ". $this->get_table_name();
    return $wpdb->get_var($sql);
  }

  /*
   * 그외 컬럼의 값
   */
  public function column_default($item, $column_name) {
    switch ($column_name) {
    case 'address':
    case 'city':
      return $item[$column_name];
    default:
      return print_r($item, true); //Show the whole array for troubleshooting purposes
    }
  }

  /*
   * cb 컬럼의 값
   */
  function column_cb($item) {
    return sprintf(
      '<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['ID']
    );
  }

  /*
   * name 컬럼의 값
   */
  function column_name($item) {
    $delete_nonce = wp_create_nonce('delete_item');

    $title = '<strong>' . $item['name'] . '</strong>';

    $actions = array(
      'delete' => sprintf('<a href="?page=%s&action=%s&customer=%s&_wpnonce=%s">Delete</a>',
      esc_attr($_REQUEST['page']), 'delete', absint($item['ID']), $delete_nonce)
    );

    return $title . $this->row_actions($actions);
  }

  function get_columns() {
    $columns = array(
      'cb'      => '<input type="checkbox" />',
      'name'    => 'Name',
      'address' => 'Address',
      'city'    => 'City'
    );

    return $columns;
  }

  public function get_sortable_columns() {
    $sortable_columns = array(
      'name' => array('name', true),
      'city' => array('city', true)
    );

    return $sortable_columns;
  }

  public function get_bulk_actions() {
    $actions = array('bulk-delete' => 'Delete');

    return $actions;
  }

  public function prepare_items() {
    $this->_column_headers = $this->get_column_info();

    $this->process_bulk_action();

    $per_page     = $this->get_items_per_page('customers_per_page', 5);
    $current_page = $this->get_pagenum();
    $total_items  = $this->record_count();

    $this->set_pagination_args(array(
      'total_items' => $total_items, //WE have to calculate the total number of items
      'per_page'    => $per_page //WE have to determine how many items to show on a page
    ));

    $this->items = $this->get_item_data($per_page, $current_page);
  }

  public function process_bulk_action() {
    if ('delete' === $this->current_action()) {
      $nonce = esc_attr($_REQUEST['_wpnonce']);

      if (wp_verify_nonce($nonce, 'delete_item')) {
        $this->delete_item(absint($_GET['customer']));
      }
    }

    if ((isset($_POST['action']) && $_POST['action'] == 'bulk-delete')
      || (isset($_POST['action2']) && $_POST['action2'] == 'bulk-delete')) {
      $delete_ids = esc_sql($_POST['bulk-delete']);

      foreach ($delete_ids as $id) {
        $this->delete_item($id);
      }
    }
  }
}
