<?php
/*
 * Plugin Name: Wordpress Admin Table
 * Description: 관리자 페이지 테이블 예제 플러그인
 * Version:   1.0.0
 * Author:    HiSEON
 * Author URI:  https://hiseon.me/
 */

class admin_table_plugin {
  protected static $_instance = null;

  public static function instance() {
    if (is_null(self::$_instance)) {
      self::$_instance = new self();
    }

    return self::$_instance;
  }

  protected function __construct() {
  }

  private function __clone() {}
  private function __sleep() {}
  private function __wakeup() {}

  public function get_table_name() {
    global $wpdb;
    return $wpdb->prefix.'customers2';
  }

  public function install() {
    global $wpdb;
    $table_name = $this->get_table_name();

    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
      $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        field_x text NOT NULL,
        field_y text NOT NULL,
        UNIQUE KEY id (id)
      ) ;";
      require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
      dbDelta( $sql );
    }
  }
}

function ATP() {
  return admin_table_plugin::instance();
}

function admin_table_activate() {
  ATP()->install();
}

register_activation_hook(__FILE__, 'admin_table_activate');
