<?php
/*
 * Plugin Name: Wordpress Admin Menu
 * Description: 관리자 메뉴 생성 예제 플러그인
 * Version:   1.0.0
 * Author:    HiSEON
 * Author URI:  https://hiseon.me/
 */

function remove_menus() {
  remove_menu_page('index.php' );                  //Dashboard
  remove_menu_page('edit.php' );                   //Posts
  remove_menu_page('upload.php' );                 //Media
  remove_menu_page('edit.php?post_type=page' );    //Pages
  remove_menu_page('edit-comments.php' );          //Comments
  remove_menu_page('themes.php' );                 //Appearance
  remove_menu_page('plugins.php' );                //Plugins
  remove_menu_page('users.php' );                  //Users
  remove_menu_page('tools.php' );                  //Tools
  remove_menu_page('options-general.php' );        //Settings

  /*
   * 메뉴 주소가 admin.php?page=test 경우, 아래와 같이 제거
   * remove_menu_page('test' );
   *
   * 서브페이지일 경우, remove_submenu_page 함수로 제거
   */
}

add_action('admin_menu', 'remove_menus');

function my_admin_menu() {
  add_menu_page('페이지 상단제목', '버튼이름', 'manage_options', 'myplugin',
    'admin_page', 'dashicons-admin-post');

  add_submenu_page('myplugin', '페이지 상단제목', '자식 메뉴1', 'manage_options', 'myplugin',
    'admin_page');

  add_submenu_page('myplugin', '페이지 상단제목', '자식 메뉴2', 'manage_options', 'myplugin-2',
    'admin_page');
}

function admin_page() {
  echo "<h3>" . $_GET['page'] . "</h3>";
}

add_action('admin_menu', 'my_admin_menu');
