#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifndef __linux__
  #pragma pack(push, 1)
#endif
struct ether_header
{
  uint8_t  ether_dhost[6];    /* destination eth addr */
  uint8_t  ether_shost[6];    /* source ether addr  */
  uint16_t ether_type;    /* packet type ID field */
}
#ifndef __linux__
  ;
  #pragma pack(pop)
#else
__attribute__ ((__packed__));
#endif

int send_wol(const char *interface, unsigned char *buf, int len);
void make_wol_packet(char *buf, const char *dstmac);
void make_ether_packet(char *buf, const char *dstmac);
