/*!
 *  @file    dumpcode.c
 *  @author  Kang IkSeon (ikseon1026@gmail.com)
 *
 *  @internal
 *       Created:  2018년 01월 30일
 *     Copyright:  Copyright (c) 2018, Kang IkSeon
 */

#include <stdio.h>
#include <ctype.h>

#include "src/dumpcode.h"

void printchar(unsigned char c) {
    if (isprint(c))
        printf("%c", c);
    else
        printf(".");
}

void dumpcode(void *ptr, int len) {
    int i;
    for (i=0; i < len; i++) {
        if (i%16 == 0)
            printf("%p  ", ((unsigned char *)ptr + i));
        printf("%02x ", ((unsigned char *)ptr)[i]);
        if (i%16-15 == 0) {
            int j;
            printf("  ");
            for (j=i-15; j <= i; j++)
                printchar(((unsigned char *)ptr)[j]);
            printf("\n");
        }
    }
    if (i%16 != 0) {
        int j;
        int spaces = (len-i+16-i%16)*3+2;
        for (j=0; j < spaces; j++)
            printf(" ");
        for (j=i-i%16; j < len; j++)
            printchar(((unsigned char *)ptr)[j]);
    }
    printf("\n");
}
