/*!
 *  @file    main.c
 *  @author  Kang IkSeon (ikseon1026@gmail.com)
 *
 *  @internal
 *       Created:  2018년 01월 30일
 *     Copyright:  Copyright (c) 2018, Kang IkSeon
 */

#include <stdio.h>
#include <stdint.h>

#include "src/dumpcode.h"

#define MAX 4096
#define SAMPLE "data/sample.pcap"

typedef struct pcap_hdr_s {
  uint32_t magic_number;   /* magic number */
  uint16_t version_major;  /* major version number */
  uint16_t version_minor;  /* minor version number */
  int32_t  thiszone;       /* GMT to local correction */
  uint32_t sigfigs;        /* accuracy of timestamps */
  uint32_t snaplen;        /* max length of captured packets, in octets */
  uint32_t network;        /* data link type */
} pcap_hdr_t;

typedef struct pcaprec_hdr_s {
  uint32_t ts_sec;         /* timestamp seconds */
  uint32_t ts_usec;        /* timestamp microseconds */
  uint32_t incl_len;       /* number of octets of packet saved in file */
  uint32_t orig_len;       /* actual length of packet */
} pcaprec_hdr_t;

int main() {
  int n, len;
  char buffer[MAX];

  pcap_hdr_t header;
  pcaprec_hdr_t packet;

  FILE *fp;

  if (!(fp= fopen(SAMPLE, "r"))) {
    return 1;
  }

  n = fread(&header, 1, sizeof(header), fp);

  printf("version : %d.%d\n\n",
      header.version_major, header.version_minor);

  while (1) {
    if (fread(&packet, 1, sizeof(packet), fp) <= 0) break;
    len = packet.incl_len;

    if (fread(buffer, 1, len, fp) <= 0) break;

    printf("packet length : %d [%d.%d]\n",
        packet.incl_len, packet.ts_sec, packet.ts_usec);
    dumpcode(buffer, len);
    printf("\n");
  }

  fclose(fp);

  return 0;
}
