/*!
 *  @file    ethernet.c
 *  @author  HiSEON (ikseon@nepirity.com)
 *
 *  @internal
 *       Created:  2018년 03월 22일
 *     Copyright:  Copyright (c) 2018, HiSEON
 */

#include <stdio.h>
#include <arpa/inet.h>
#include <net/ethernet.h>

#include "src/ethernet.h"

void dump_ethernet_header(const u_char *pkt_data) {
  struct ether_header *header = (struct ether_header *)pkt_data;

  const char *name = NULL;

  u_int8_t *dmac = header->ether_dhost;
  u_int8_t *smac = header->ether_shost;
  u_int16_t type = ntohs(header->ether_type);

  switch (type) {
    case ETHERTYPE_IP:
      name = "IP";
      break;
    case ETHERTYPE_ARP:
      name = "ARP";
      break;
    default:
      name = "Unknwon";
      break;
  }

  printf("%02x:%02x:%02x:%02x:%02x:%02x => " \
      "%02x:%02x:%02x:%02x:%02x:%02x (%s) \n",
  smac[0], smac[1], smac[2], smac[3], smac[4], smac[5],
  dmac[0], dmac[1], dmac[2], dmac[3], dmac[4], dmac[5], name);
}
